CLS
@echo off
TITLE DECTalk Built-in Dictionary Compilation Script
rem Built-in dictionary compilation script for DECTalk.
rem This script requires dic.exe from your DECTalk build.
rem By default, dic.exe must be placed alongside this script in the same directory.
rem If dic.exe is located elsewhere, the PATH variable must be set accordingly. See further remarks in this script for details.

rem Set variables used throughout this script.
rem Set the DECTalk language whose dictionary is being compiled, i.e., fr, gr, la, nws_la, sp, us, nws_us, uk, etc.
rem The default is us for standard DECTalk and nws_us for the National Weather Service version.
SET DTLKLANG=nws_us
rem Set the current path.
rem The default is to use the current directory, i.e., the directory from where this script is executed. By default, the trailing backslash is included.
SET "PATH=%~dp0"
rem Set the filename of the dictionary compiler to use. The default is dic.exe, relative to the specified path.
SET "COMPILERNAME=%PATH%dic.exe"
rem The dictionary source and destination filenames are specified next, by default relative to the path.
rem Note 1, the dictionary source file can have any name you prefer.
rem Note 2, the default source filename is dic_DTLKLANG.txt, where DTLKLANG is the DECTalk language set previously.
rem Note 3, since DECTalk expects specific filenames for built-in dictionaries, the destination file may only be moved or copied.
rem Note 4, The destination file must be placed in a directory alongside the DECTalk executable, i.e., dectalk.dll, speak.exe, etc.
rem Note 5, if you moved either of the dictionary files, you must change the next 2 lines to specify the new filenames.
SET "DICSOURCEFILE=%PATH%dic_%DTLKLANG%.txt"
SET "DICDESTFILE=%PATH%dtalk_%DTLKLANG%.dic"
rem Set the type of dictionary to compile. The allowed values are win32 and dos. The default is win32.
rem Note that win32 is used for Windows and other operating systems, except for MS-DOS, which uses dos.
SET "DICTYPE=win32"
rem Set what to do after compilation of the dictionary. Allowed values are exit for exit or pause for pause. The default is exit.
rem Note that this script will always pause if an error occurs.
SET POSTCOMPILE=exit

rem Check for the existence of both the specified compiler and dictionary source file and display helpful hints if either or both are missing.
IF EXIST "%COMPILERNAME%" (
  IF EXIST "%DICSOURCEFILE%" (
    GOTO compile
  ) ELSE (
    CLS
    ECHO.
    ECHO The expected dictionary source file:
    ECHO "%DICSOURCEFILE%"
    ECHO could not be found.
    ECHO Please double-check both the DECTalk language and dictionary source filename specified within this script and try again.
    GOTO pausefunc
  )
) ELSE (
  IF EXIST "%DICSOURCEFILE%" (
    CLS
    ECHO.
    ECHO The expected dictionary compiler:
    ECHO "%COMPILERNAME%"
    ECHO could not be found.
    ECHO Please double-check the compiler name specified within this script and try again.
    GOTO pausefunc
  ) ELSE (
    CLS
    ECHO.
    ECHO The expected dictionary source file:
    ECHO "%DICSOURCEFILE%"
    ECHO and expected dictionary compiler:
    ECHO "%COMPILERNAME%"
    ECHO could not be found.
    ECHO Please double-check the DECTalk language, dictionary source filename, and compiler name specified within this script and try again.
    GOTO pausefunc
  )
)

rem Run the compiler to compile the dictionary.
:compile
CLS
ECHO.
ECHO Compiling dictionary...
ECHO.
"%COMPILERNAME%" "%DICSOURCEFILE%" "%DICDESTFILE%" /t:%DICTYPE%
IF %ERRORLEVEL% GTR 0 (
ECHO.
ECHO Dictionary compilation failed. Please check the dictionary source file and try again.
  GOTO pausefunc
) ELSE (
  ECHO.
  ECHO Dictionary compilation completed.
  GOTO %POSTCOMPILE%func
)

rem Pause so messages can be read.
:pausefunc
ECHO.
ECHO Press any key to exit.
PAUSE >nul
GOTO exitfunc

rem Exit when the end of the script is reached.
:exitfunc
GOTO:EOF
